/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef STRINGHELPER_H
#define STRINGHELPER_H

#include "../types.h"
#include <string>
#include <vector>
#include <iostream>     // std::cout, std::endl
#include <iomanip>      // std::setfill, std::setw
#include <sstream>

#include "../protocol/CPPrfeProtocolConstants.h"

#define BitConverter    StringHelper

class StringHelper
{
public:
    StringHelper();

    static std::string toString(std::vector<byte> data);

    template< typename T >
    static std::string toHexString( T i )
    {
      std::stringstream stream;
      stream << "0x"
             << std::setfill ('0') << std::setw(sizeof(T)*2)
             << std::hex << i;
      return stream.str();
    }

    template< typename T >
    static std::string toIntString( T i )
    {
      std::stringstream stream;
      stream << i;
      return stream.str();
    }

    template< typename T >
    static std::string toIntString( T i, int fieldwidth )
    {
      std::stringstream stream;
      stream << std::setfill (' ') << std::setw(fieldwidth) << std::dec << i;
      return stream.str();
    }

    static std::string toString(CPPrfeReaderInterface::eRFE_CURRENT_READER_STATE state);
    static std::string toString(CPPrfeReaderInterface::eRFE_CURRENT_SYSTEM sys);
    static std::string toString(CPPrfeReaderInterface::eRFE_RET_VALUE ret);
};

#endif // STRINGHELPER_H
